<?php  
include_once 'db.php';

$date = date('Y-m-d H:i:s');
$report = $_POST['report'];
$durationval = $_POST['durationselectval'];
date_default_timezone_set("Asia/Kolkata"); // India time (GMT+5:30)

// Get selected columns from POST request
$selectedColumns = isset($_POST['selectedColumns']) ? $_POST['selectedColumns'] : array();

if ($durationval == 1) {
    $durationvals = date('Y-m-d');
} elseif ($durationval == 2) {
    $durationvals = date("Y-m-d", strtotime("yesterday"));
} elseif ($durationval == 3) {
    $sqlvals = "SELECT subdate(curdate(), WEEKDAY(curdate()) + 7) AS Monday, subdate(curdate(), WEEKDAY(curdate()) + 1) AS Sunday";
    $resultvals = $connection->query($sqlvals);
    $rowweeks = mysqli_fetch_array($resultvals);
    $Monday = $rowweeks['Monday'];
    $Sunday = $rowweeks['Sunday'];
    $durationvals = $Monday . " To " . $Sunday;
} elseif ($durationval == 4) {
    $sqlvalsrows = "SELECT last_day(curdate() - interval 2 month) + interval 1 day AS firstday, last_day(curdate() - interval 1 month) AS lastday";
    $resultvalsquery = $connection->query($sqlvalsrows);
    $rowweeksfetch = mysqli_fetch_array($resultvalsquery);
    $firstday = $rowweeksfetch['firstday'];
    $lastday = $rowweeksfetch['lastday'];
    $durationvals = $firstday . " To " . $lastday;
} elseif ($durationval == 5) {
    $customdates = addslashes($_POST['customdates']);
    $dateRange = explode(' - ', $customdates);
    $startDate = date('Y-m-d', strtotime($dateRange[0]));
    $endDate = date('Y-m-d', strtotime($dateRange[1]));
    $durationvals = $startDate . ' - ' . $endDate;
}

$sql = "INSERT INTO reports SET report = '$report', duration = '$rangedate', rangedate = '$date', durationval = '$durationvals'";
$sqlexecute = mysqli_query($connection, $sql);
$last_id = mysqli_insert_id($connection);

if ($report == '3') {
    // Function to filter and format data for Excel
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // Define all potential fields for the report
    $fields = array('Customer Name', 'Customer Mobile', 'Balance Amount', 'Due', 'Email', 'GSTIN', 'Tag', 'Type', 'Create Date', 'Referral Code');

    // Ensure $selectedColumns is populated correctly
    $selectedFields = array_intersect($fields, $selectedColumns);
    if (empty($selectedFields)) {
        $selectedFields = $fields; // Default to all fields if none selected
    }

    // Prepare the Excel data with selected column names
    $excelData = implode("\t", array_values($selectedFields)) . "\n";

    // SQL query to fetch customer data
    $q = "SELECT id, displayname, phoneno, gstno, email, referralcode, customertype, currentdate 
          FROM customer 
          WHERE delete_status = 0";
    $result = $connection->query($q);

    // Process each row of the result
    foreach ($result as $row) {
        $id = $row['id'];

        // Fetch order details
        $sqlorder = "SELECT SUM(grandtotal) AS orderamount 
                     FROM orders 
                     WHERE customerid = '$id' AND delete_status = 0 
                     GROUP BY customerid";
        $resultorder = $connection->query($sqlorder);
        $rowsorder = mysqli_fetch_array($resultorder);
        $orderamount = isset($rowsorder['orderamount']) ? $rowsorder['orderamount'] : 0;

        // Fetch customer payment details
        $sqlcustomer = "SELECT SUM(amount) AS totalamount 
                        FROM customerpayment 
                        WHERE customerid = '$id' 
                        GROUP BY customerid";
        $results = $connection->query($sqlcustomer);
        $rows = mysqli_fetch_array($results);
        $totalamount = isset($rows['totalamount']) ? $rows['totalamount'] : 0;

        // Calculate balance and due amount
        $balance = $orderamount - $totalamount;
        $due = $orderamount - $totalamount;
        $advance = $due < 0 ? abs($due) : '--';
        $dues = $due > 0 ? abs($due) : '--';

        // Determine customer type label
        $customertypelable = $row['customertype'];
        if ($customertypelable == 1) {
            $customertypelable = "Customer";
        } elseif ($customertypelable == 2) {
            $customertypelable = "Retailer";
        } else {
            $customertypelable = "Sales Counter";
        }

        // Create the line data for each row
        $lineData = array(
            'Customer Name' => isset($row['displayname']) ? $row['displayname'] : 'N/A',
            'Customer Mobile' => isset($row['phoneno']) ? $row['phoneno'] : 'N/A',
            'Balance Amount' => $balance,
            'Due' => $dues,
            'Email' => isset($row['email']) ? $row['email'] : 'N/A',
            'GSTIN' => isset($row['gstno']) ? $row['gstno'] : 'N/A',
            'Tag' => $customertypelable,
            'Type' => $customertypelable,
            'Create Date' => isset($row['currentdate']) ? $row['currentdate'] : 'N/A',
            'Referral Code' => isset($row['referralcode']) ? $row['referralcode'] : 'N/A'
        );

        // Filter and add only selected fields
        $selectedLineData = array_intersect_key($lineData, array_flip($selectedFields));
        array_walk($selectedLineData, 'filterData');
        $excelData .= implode("\t", array_values($selectedLineData)) . "\n";
    }

    // Generate file name
    $fileName = "reportsfiles/" . "Customer-" . $durationvals . ".xls";

    // Save data to Excel file
    file_put_contents($fileName, $excelData);

    // Update the report with the file name
    $sql6 = "UPDATE reports SET excelname = '$fileName' WHERE id = '$last_id'";
    $sqlexecute3 = mysqli_query($connection, $sql6);
}

/// report ='4' ordero item report
if ($report == '4') {

    // Create connection
    $connection = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    // Function to sanitize data for Excel output
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // Define the file name for the Excel file
    $fileName = "reportsfiles/OrderItemReport-" . $durationvals . ".xls";

    // Define the column headers for the Excel file
    $fields = array(
        'Order Id', 'Order Status', 'Type', 'Delivery Mode', 'Payment Mode', 'Order Date',
        'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name',
        'Item Sku', 'Item Price', 'Item Qty', 'HSN', 'State', 'State Code', 'SGST', 'SGST%',
        'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Tax', 'Item Total'
    );

    // Display column names as the first row
    $excelData = implode("\t", $fields) . "\n";

    // Base query for orders
    $q = "SELECT i.id,i.invoicedate,i.invoiceno, c.displayname AS customer_name, c.phoneno AS customer_mobile, pd.productname AS item_name, pd.hsn AS hsn,pd.sku, id.qty AS quantity, id.price AS price,
                o.orderid,o.createdate,o.actionstatus,cp.paymenttype
              FROM invoice i
              LEFT JOIN customer c ON i.customerid = c.id
              LEFT JOIN invoicedata id ON i.id = id.invoiceid
              LEFT JOIN product pd ON id.productid = pd.id
              LEFT JOIN orders o ON o.id=i.id
              LEFT JOIN customerpayment cp ON cp.id= i.id";

    // Add date filter based on invoice date
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');  
        $q .= " WHERE i.invoicedate = '$durationvals'"; 
    } else if ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));   
        $q .= " WHERE i.invoicedate = '$durationvals'";   
    } else if ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);  
        $rowweeks = mysqli_fetch_array($resultvals);  
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];  
        $q .= " WHERE i.invoicedate >= '$Monday' AND i.invoicedate <= '$Sunday'";  
    } else if ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows); 
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);   
        $firstday = $rowweeksfetch['firstday'];     
        $lastday = $rowweeksfetch['lastday']; 
        $q .= " WHERE i.invoicedate >= '$firstday' AND i.invoicedate <= '$lastday'";  
    } else if ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);   
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $q .= " WHERE i.invoicedate >= '$startDate' AND i.invoicedate <= '$endDate'";  
    }

    $result = $connection->query($q);  

    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['paymenttype']) {
            case '1':
                $paymenttype = "Cash";
                $paymentmode = "Cash";
                break;
            case '2':
                $paymenttype = "Card";
                $paymentmode = "Card"; // Adjusted to match payment type
                break;
            case '3':
                $paymenttype = "UPI";
                $paymentmode = "Bank";
                break;
            case '4':
                $paymenttype = "Bank Transfer"; // Example: Adjust as per your system's logic
                $paymentmode = "Bank";
                break;
            case '5':
                $paymenttype = "Cheque";
                $paymentmode = "Cheque"; // Adjusted to match payment type
                break;
            default:
                $paymenttype = "N/A";
                $paymentmode = "N/A";
        }
        
                // Determine order status
                $label = "";
                if ($row['actionstatus'] == "1") {
                    $label = "New";
                } elseif ($row['actionstatus'] == "2") {
                    $label = "Confirmed";
                } elseif ($row['actionstatus'] == "3") {
                    $label = "Dispatched";
                } elseif ($row['actionstatus'] == "4") {
                    $label = "Delivered";
                } elseif ($row['actionstatus'] == "5") {
                    $label = "Cancelled";
                } elseif ($row['actionstatus'] == "6") {
                    $label = "Completed";
                } else {
                    $label = "Unknown";
                }
        

                $total=$row['price']*$row['quantity'];
                $sgst_percent = 2.5;
                $cgst_percent = 2.5;
                $igst_percent = 5.0;
                $sgst = $total * ($sgst_percent / 100);
                $cgst = $total * ($cgst_percent / 100);
                $igst = $total * ($igst_percent / 100);

                $itemtotal=$total+$sgst+$cgst+$igst;
        // Prepare line data for Excel
        $lineData = array(
            $row['orderid'], 
            $label, 
            $row['Type'], 
            $row['Delivery Mode'], 
            $paymenttype, 
            $row['createdate'], 
            $row['invoiceno'], 
            $row['invoicedate'], 
            $row['customer_name'], 
            $row['customer_mobile'], 
            $row['item_name'], 
            $row['sku'], 
            $row['price'], 
            $row['quantity'], 
            $row['hns'], 
            $row['State'], 
            $row['State Code'], 
            $sgst, 
            $sgst_percent, 
            $cgst, 
            $cgst_percent, 
            $igst, 
            $igst_percent, 
            0, 
            0, 
            0, 
            $itemtotal
        ); 

        // Apply data filtering
        array_walk($lineData, 'filterData');

        // Concatenate line data into Excel format
        $excelData .= implode("\t", $lineData) . "\n";
    } 

    // Write data to file
    file_put_contents($fileName, $excelData);

    // Update report entry in the database
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'"; 
    $sqlexecute3 = mysqli_query($connection, $sql6);
}
	  
	//  report ='7' Gst      Report    
    if ($report == '7') {
        // Function to filter Excel data
        function filterData(&$str) {
            $str = preg_replace("/\t/", "\\t", $str);
            $str = preg_replace("/\r?\n/", "\\n", $str);
            if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
        }
    
        // Define Excel headers
        $fields = array('Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name', 'HSN', 'Quantity', 'Price Per Unit', 'SGST', 'SGST%', 'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Total');
        // Display column names as first row
        $excelData = implode("\t", array_values($fields)) . "\n";
    
        // Determine the duration for the filename
        $durationvals = '';
        if ($durationval == 1) {
            $durationvals = date('Y-m-d');
        } elseif ($durationval == 2) {
            $durationvals = date("Y-m-d", strtotime("yesterday"));
        } elseif ($durationval == 3 || $durationval == 4) {
            // Date variables for weekly or monthly data
            $durationvals = $durationval == 3 ? "Weekly" : "Monthly";
        } elseif ($durationval == 5) {
            $customdates = addslashes($_POST['customdates']);
            $dateRange = explode(' - ', $customdates);
            $startDate = date('Y-m-d', strtotime($dateRange[0]));
            $endDate = date('Y-m-d', strtotime($dateRange[1]));
            $durationvals = $startDate . "_to_" . $endDate;
        } else {
            $durationvals = "Undefined";  // Default if no valid durationval is provided
        }
    
        // Define file name
        $fileName = "reportsfiles/Gstsales-" . $durationvals . ".xls";
    
        // Build the SQL query
        $q = "SELECT i.*, c.displayname AS customer_name, c.phoneno AS customer_mobile, pd.productname AS item_name, pd.hsn AS hsn, id.qty AS quantity, id.price AS price
              FROM invoice i
              LEFT JOIN customer c ON i.customerid = c.id
              LEFT JOIN invoicedata id ON i.id = id.invoiceid
              LEFT JOIN product pd ON id.productid = pd.id
              WHERE i.delete_status = '0' AND i.reportstaus = '0'";
    
        // Apply date filter
        if ($durationval == 1) {
            $q .= " AND DATE(i.invoicedate) = '$durationvals'";
        } elseif ($durationval == 2) {
            $q .= " AND DATE(i.invoicedate) = '$durationvals'";
        } elseif ($durationval == 5) {
            $q .= " AND DATE(i.invoicedate) BETWEEN '$startDate' AND '$endDate'";
        } // No specific SQL filtering for weekly/monthly as it's not defined in the original context
    
        // Execute the query
        $result = $connection->query($q);
    
        // Check if the query executed successfully
        
            // Process the query result
            foreach ($result as $row) {
                $id = $row['id'];
                $customerid = $row['customerid'];
    
                // Fetch customer and product details
                $sqlinvoicedata = "SELECT * FROM invoicedata WHERE invoiceid='$id'";
                $sqlexecutes = mysqli_query($connection, $sqlinvoicedata);
                $invoicedatarows = mysqli_fetch_array($sqlexecutes);
                $productid = $invoicedatarows['productid'];
    
                $sql2 = "SELECT * FROM customer WHERE id='$customerid'";
                $sqlexecute2 = mysqli_query($connection, $sql2);
                $customerrows = mysqli_fetch_array($sqlexecute2);
    
                $sql3 = "SELECT * FROM product WHERE id='$productid'";
                $sqlexecute3 = mysqli_query($connection, $sql3);
                $productrows = mysqli_fetch_array($sqlexecute3);
    
                // Calculate total amount
                $total = $invoicedatarows['qty'] * $invoicedatarows['price'];
                $sgst_percent = 2.5;
                $cgst_percent = 2.5;
                $igst_percent = 5.0;
                $sgst = $total * ($sgst_percent / 100);
                $cgst = $total * ($cgst_percent / 100);
                $igst = $total * ($igst_percent / 100);
    
                // Prepare line data
                $lineData = array(
                    $row['invoiceno'],
                    $row['invoicedate'],
                    isset($customerrows['displayname']) ? $customerrows['displayname'] : 'N/A',
                    isset($customerrows['phoneno']) ? $customerrows['phoneno'] : 'N/A',
                    isset($productrows['productname']) ? $productrows['productname'] : 'N/A',
                    isset($productrows['hsn']) ? $productrows['hsn'] : 'N/A',
                    isset($invoicedatarows['qty']) ? $invoicedatarows['qty'] : 0,
                    isset($invoicedatarows['price']) ? $invoicedatarows['price'] : 0.0,
                    $sgst,         // SGST amount
                    $sgst_percent, // SGST%
                    $cgst,         // CGST amount
                    $cgst_percent, // CGST%
                    $igst,         // IGST amount
                    $igst_percent, // IGST%
                    '0.0',         // CESS amount
                    '0.0',         // CESS%
                    $total
                );
    
                // Filter and add to Excel data
                array_walk($lineData, 'filterData');
                $excelData .= implode("\t", array_values($lineData)) . "\n";
            }
        
    
            // Save data to Excel file
            file_put_contents($fileName, $excelData);
    
            // Update reports table with file name
            $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'";
            $sqlexecute3 = mysqli_query($connection, $sql6);
    
    }
    



	  
	//  report ='9'  append   report 

    if ($report == '9') {
        // Function to filter Excel data 
        function filterData(&$str) { 
            $str = preg_replace("/\t/", "\\t", $str); 
            $str = preg_replace("/\r?\n/", "\\n", $str); 
            if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"'; 
        }
    
        $fileName = "reportsfiles/Append-" . $durationvals . ".xls"; // Adjusted file name
    
        // Define Excel header fields
        $fields = [
            'cartid', 'createdate', 'customername', 'customermoblie', 'deliverymode',
            'pickupname', 'pickupmoblie', 'subtotal', 'shippingcharge', 'packagingcharge',
            'paymentcharge', 'couponcode', 'coupondiscount', 'paymentdiscount', 'taxamount',
            'totalamount', 'utmid', 'utmcampaign', 'addressname', 'addressmobile',
            'street1', 'street2', 'city', 'state', 'pincode', 'itemsku', 'itemname',
            'itemqty', 'itemprice'
        ];
    // Ensure $selectedColumns is populated correctly
   // $selectedFields = array_intersect($fields, $selectedColumns);
   // if (empty($selectedFields)) {
      //  $selectedFields = $fields; // Default to all fields if none selected
   // }

    // Prepare the Excel data with selected column names
    $excelData = implode("\t", array_values($selectedFields)) . "\n";
    $excelData = implode("\t", $fields) . "\n";
    
        // Base query
        $q = "SELECT * FROM `abandonedcart`";
        if ($durationval == 1) {
            $durationvals = date('Y-m-d');
            $q .= " WHERE createdate = '$durationvals'";
        } elseif ($durationval == 2) {
            $durationvals = date("Y-m-d", strtotime("yesterday"));
            $q .= " WHERE createdate = '$durationvals'";
        } elseif ($durationval == 3) {
            $sqlvals = "SELECT DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) + 7 DAY) AS Monday, DATE_SUB(CURDATE(), INTERVAL WEEKDAY(CURDATE()) - 1 DAY) AS Sunday";
            $resultvals = $connection->query($sqlvals);
            if (!$resultvals) {
                die("Query failed: " . $connection->error);
            }
            $rowweeks = mysqli_fetch_array($resultvals);
            $Monday = $rowweeks['Monday'];
            $Sunday = $rowweeks['Sunday'];
            $q .= " WHERE createdate >= '$Monday' AND createdate <= '$Sunday'";
        } elseif ($durationval == 4) {
            $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
            $resultvalsquery = $connection->query($sqlvalsrows);
            if (!$resultvalsquery) {
                die("Query failed: " . $connection->error);
            }
            $rowweeksfetch = mysqli_fetch_array($resultvalsquery);
            $firstday = $rowweeksfetch['firstday'];
            $lastday = $rowweeksfetch['lastday'];
            $q .= " WHERE createdate >= '$firstday' AND createdate <= '$lastday'";
        } elseif ($durationval == 5) {
            $customdates = mysqli_real_escape_string($connection, $_POST['customdates']);
            $dateRange = explode(' - ', $customdates);
            $startDate = date('Y-m-d', strtotime($dateRange[0]));
            $endDate = date('Y-m-d', strtotime($dateRange[1]));
            $q .= " WHERE createdate >= '$startDate' AND createdate <= '$endDate'";
        } else {
            die("Invalid duration value.");
        }
        
        // Execute query
        $result = $connection->query($q);
        if (!$result) {
            die("Query failed: " . $connection->error);
        }
        
     
        while ($row = mysqli_fetch_assoc($result)) {
            $lineData = [
                $row['cartid'], $row['createdate'], $row['customername'], $row['customermoblie'],
                $row['deliverymode'], $row['pickupname'], $row['pickupmoblie'], $row['subtotal'],
                $row['shippingcharge'], $row['packagingcharge'], $row['paymentcharge'], $row['couponcode'],
                $row['coupondiscount'], $row['paymentdiscount'], $row['taxamount'], $row['totalamount'],
                $row['utmid'], $row['utmcampaign'], $row['addressname'], $row['addressmobile'],
                $row['street1'], $row['street2'], $row['city'], $row['state'], $row['pincode'],
                $row['itemsku'], $row['itemname'], $row['itemqty'], $row['itemprice']
            ];
             // Filter and add only selected fields
       // $selectedLineData = array_intersect_key($lineData, array_flip($selectedFields));
        //array_walk($selectedLineData, 'filterData');
        //$excelData .= implode("\t", array_values($selectedLineData)) . "\n";
        
            // Apply data filtering
            array_walk($lineData, 'filterData');
        
            // Concatenate line data into Excel format
            $excelData .= implode("\t", $lineData) . "\n";
        }
        
    
    // Write data to file
    file_put_contents($fileName, $excelData);

    // Update report entry in database
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'"; 
    $sqlexecute3 = mysqli_query($connection, $sql6);    
    }
    
    
//payment   report 
if ($report == '5') {
    // Function to filter Excel data
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // Define Excel headers
    $fields = array(
        'Order Id', 'Order Status', 'Order Date', 'Order Amount', 'Order Type',
        'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Payment Amount',
        'Payment Method', 'Payment Mode', 'Gateway', 'Payment Date', 'Settle Date', 'Reference Id',
        'Notes', 'Settled Amount'
    );
    $excelData = implode("\t", array_values($fields)) . "\n";

    // Base SQL query with join to include order-related information
    $q = "SELECT 
            o.orderid, o.orderstatus, o.createdate, o.grandtotal, o.actionstatus,
            i.invoiceno, i.invoicedate, i.customerid,
            p.amount, p.paymenttype, p.paymentdate, p.referenceid, p.notes, p.id AS payment_id
          FROM orders o
          LEFT JOIN invoice i ON o.id = i.orderid
          LEFT JOIN customerpayment p ON o.id = p.orderid";

    // Apply date filter based on $durationval
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');
        $q .= " WHERE DATE(o.createdate) = '$durationvals'";
    } elseif ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));
        $q .= " WHERE DATE(o.createdate) = '$durationvals'";
    } elseif ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, 
                           SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);
        $rowweeks = mysqli_fetch_array($resultvals);
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];
        $q .= " WHERE DATE(o.createdate) >= '$Monday' AND DATE(o.createdate) <= '$Sunday'";
    } elseif ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday,
                               LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows);
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);
        $firstday = $rowweeksfetch['firstday'];
        $lastday = $rowweeksfetch['lastday'];
        $q .= " WHERE DATE(o.createdate) >= '$firstday' AND DATE(o.createdate) <= '$lastday'";
    } elseif ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $q .= " WHERE DATE(o.createdate) >= '$startDate' AND DATE(o.createdate) <= '$endDate'";
    }

    error_log("SQL Query: " . $q); // Check error log for the actual query

    // Execute the query
    $result = $connection->query($q);

    // Check if the query executed successfully
    if (!$result) {
        die("Query failed: " . mysqli_error($connection));
    }

    // Check if there are any results
    if ($result->num_rows == 0) {
        die("No records found for the given duration. SQL: $q"); // Add SQL query to error message
    }

    // Prepare the directory path
    $directory = 'reportsfiles';
    if (!is_dir($directory)) {
        if (!mkdir($directory, 0755, true)) {
            die("Failed to create directory: $directory");
        }
    }

    // Generate a unique file name
    $fileName = $directory . '/payment_report_' . $durationvals . '.xls';

    // Process the query result
    while ($row = $result->fetch_assoc()) {
        $customerid = $row['customerid'];
        $payment_id = $row['payment_id'];

        // Retrieve settled amount and settle date from cheques table
        $sqlcheques = "SELECT settledamount, settleddate FROM cheques WHERE customerpaymentid = '$payment_id'";
        $sqlchequesexecute = mysqli_query($connection, $sqlcheques);
        $chequesrows = mysqli_fetch_array($sqlchequesexecute);
        $settledamount = $chequesrows['settledamount'];
        $settleddate = $chequesrows['settleddate'];

        // Retrieve customer details
        $sql2 = "SELECT displayname, phoneno FROM customer WHERE id = '$customerid'";
        $sqlexecute2 = mysqli_query($connection, $sql2);
        $customerrows = mysqli_fetch_array($sqlexecute2);

        // Determine payment type and payment mode
     // Determine payment type and payment mode
switch ($row['paymenttype']) {
    case '1':
        $paymenttype = "Cash";
        $paymentmode = "Cash";
        break;
    case '2':
        $paymenttype = "Card";
        $paymentmode = "Card"; // Adjusted to match payment type
        break;
    case '3':
        $paymenttype = "UPI";
        $paymentmode = "Bank";
        break;
    case '4':
        $paymenttype = "Bank Transfer"; // Example: Adjust as per your system's logic
        $paymentmode = "Bank";
        break;
    case '5':
        $paymenttype = "Cheque";
        $paymentmode = "Cheque"; // Adjusted to match payment type
        break;
    default:
        $paymenttype = "N/A";
        $paymentmode = "N/A";
}


        // Determine order status
        $label = "";
        if ($row['actionstatus'] == "1") {
            $label = "New";
        } elseif ($row['actionstatus'] == "2") {
            $label = "Confirmed";
        } elseif ($row['actionstatus'] == "3") {
            $label = "Dispatched";
        } elseif ($row['actionstatus'] == "4") {
            $label = "Delivered";
        } elseif ($row['actionstatus'] == "5") {
            $label = "Cancelled";
        } elseif ($row['actionstatus'] == "6") {
            $label = "Completed";
        } else {
            $label = "Unknown";
        }

        // Ensure date fields are valid and properly formatted
        $createdate = !empty($row['createdate']) && strtotime($row['createdate']) ? date("d-m-Y", strtotime($row['createdate'])) : '';
        $invoicedate = !empty($row['invoicedate']) && strtotime($row['invoicedate']) ? date("d-m-Y", strtotime($row['invoicedate'])) : '';
        $paymentdate = !empty($row['paymentdate']) && strtotime($row['paymentdate']) ? date("d-m-Y", strtotime($row['paymentdate'])) : '';
        $settleddate = !empty($settleddate) && strtotime($settleddate) ? date("d-m-Y", strtotime($settleddate)) : '';

        // Prepare line data
        $lineData = array(
            $row['orderid'], // Order Id
            $label, // Order Status
            $createdate, // Order Date
            $row['grandtotal'], // Order Amount
            0, // Order Type
            $row['invoiceno'], // Invoice Id
            $invoicedate, // Invoice Date
            !empty($customerrows['displayname']) ? $customerrows['displayname'] : '', // Customer Name
            !empty($customerrows['phoneno']) ? $customerrows['phoneno'] : '', // Customer Mobile
            !empty($row['amount']) ? $row['amount'] : '', // Payment Amount
            $paymenttype, // Payment Method
            $paymentmode, // Payment Mode
            'Gateway', // Gateway (assuming this is static or needs specific logic to determine)
            $paymentdate, // Payment Date
            $settleddate, // Settle Date
            !empty($row['referenceid']) ? $row['referenceid'] : '', // Reference Id
            !empty($row['notes']) ? $row['notes'] : '', // Notes
            !empty($settledamount) ? $settledamount : '' // Settled Amount
        );

        // Filter and add to Excel data
        array_walk($lineData, 'filterData');
        $excelData .= implode("\t", array_values($lineData)) . "\n";
    }

    // Ensure the directory is writable
    if (!is_writable($directory)) {
        die("Directory '$directory' is not writable. Please check permissions.");
    }

    // Save data to Excel file
    if (file_put_contents($fileName, $excelData) === false) {
        die("Failed to write data to file '$fileName'.");
    }

    // Update reports table with file name
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'";
    $sqlexecute3 = mysqli_query($connection, $sql6);

    if (!$sqlexecute3) {
        die("Failed to update reports table: " . mysqli_error($connection));
    }
}


  // ** Daily sales summary  start   **/

  if ($report == '8') {
    // Function to filter Excel data
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // File name for the Excel file
    $fileName = "reportsfiles/Dailysalessummary-" . $durationvals . ".xls";

 // Initialize Excel data with headers
    $fields = array(
        'Date', 'Type', 'Sale Price', 'Packaging Fee', 'Delivery Fee', 'Payment Charge',
        'Payment Discount', 'Discount', 'Round Discount', 'Coupon Discount', 'Total'
    );

    // Start Excel data
    $excelData = implode("\t", $fields) . "\n";
    // Define date range filtering if available for invoices
    $q = "SELECT i.id, i.invoicedate AS date, 'INVOICE' AS type,
                 SUM(id.amount) AS saleprice,
                 i.grandtotal AS total,
                 i.totalsavings AS discount,
                 i.discountvalue AS rounddiscount,
                 i.shipping AS deliveryfee
          FROM invoice i
          INNER JOIN invoicedata id ON i.id = id.invoiceid";

    // Apply date range filtering based on $durationval
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');  
        $q .= " WHERE i.invoicedate = '$durationvals'"; 
    } else if ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));   
        $q .= " WHERE i.invoicedate = '$durationvals'";   
    } else if ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);  
        $rowweeks = mysqli_fetch_array($resultvals);  
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];  
        $q .= " WHERE i.invoicedate >= '$Monday' AND i.invoicedate <= '$Sunday'";  
    } else if ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows); 
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);   
        $firstday = $rowweeksfetch['firstday'];     
        $lastday = $rowweeksfetch['lastday']; 
        $q .= " WHERE i.invoicedate >= '$firstday' AND i.invoicedate <= '$lastday'";  
    } else if ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);   
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $q .= " WHERE i.invoicedate >= '$startDate' AND i.invoicedate <= '$endDate'";  
    }

    $q .= " GROUP BY i.id"; 

    // Query for Invoice data
    $result = mysqli_query($connection, $q);
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            // Calculate total
            $total = $row['saleprice'] - $row['rounddiscount'];

            // Prepare line data for Excel
            $lineData = array(
                $row['date'],
                $row['type'],
                $row['saleprice'],
                0.0, // Packaging Fee
                $row['deliveryfee'],
                0.0, // Payment Charge
                0.0, // Payment Discount
                $row['discount'],
                $row['rounddiscount'],
                0.0, // Coupon Discount
                $total
            );

            // Apply data filtering
            array_walk($lineData, 'filterData');

            // Concatenate line data into Excel format
            $excelData .= implode("\t", array_values($lineData)) . "\n";
        }
    }

    // Define date range filtering for orders if available
    $dateFilterOrder = "";
    if (!empty($rangedate)) {
        $dates = explode('to', $rangedate);
        $fromDate = trim($dates[0]);
        $toDate = trim($dates[1]);
        $dateFilterOrder = " WHERE DATE(o.orderdate) >= '$fromDate' AND DATE(o.orderdate) <= '$toDate'";
    }

    // Query for Order data
    $q = "SELECT o.orderdate AS date, 'PURCHASE' AS type,
                 SUM(d.amount) AS saleprice,
                 o.total AS total,
                 o.shipping AS deliveryfee
          FROM `order` o
          INNER JOIN orderdata d ON o.id = d.orderid
          $dateFilterOrder
          GROUP BY o.id"; // Apply date filter and group by order ID

    $result = mysqli_query($connection, $q);
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            // Prepare line data for Excel
            $lineData = array(
                $row['date'],
                $row['type'],
                $row['saleprice'],
                0.0, // Packaging Fee
                $row['deliveryfee'],
                0.0, // Payment Charge
                0.0, // Payment Discount
                0.0, // Discount
                0.0, // Round Discount
                0.0, // Coupon Discount
                $row['total']
            );

            // Apply data filtering
            array_walk($lineData, 'filterData');

            // Concatenate line data into Excel format
            $excelData .= implode("\t", array_values($lineData)) . "\n";
        }
    }

    // Write data to file
    file_put_contents($fileName, $excelData);

    // Update report entry in the database
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'";
    $sqlexecute3 = mysqli_query($connection, $sql6);
}

//   $report  2  Invoice   report 

if ($report == '2') {
    // Filter the excel data 
    function filterData(&$str) { 
        $str = preg_replace("/\t/", "\\t", $str); 
        $str = preg_replace("/\r?\n/", "\\n", $str); 
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"'; 
    }

    $fileName = "reportsfiles/Invoice-" . $durationvals . ".xls";

    $fields = array(
        'Invoice Id', 'Invoice Date', 'Create Date', 'Order Id', 'Customer Name', 'Customer Mobile',
        'Coupon Code', 'Sale Price', 'Shipping Charge', 'Packaging Charge', 'Payment Discount',
        'Coupon Discount', 'Round Off', 'Discount', 'Tax Amount', 'Total Amount', 'Due Amount',
        'Create By', 'Modify By'
    );

    //column selection
    //$selectedFields = array_intersect($fields, $selectedColumns);
    //if (empty($selectedFields)) {
      //  $selectedFields = $fields; // Default to all fields if none selected
    //}

    // Display column names as first row 
    $excelData = implode("\t", $fields) . "\n";

    // Base query 
    $q = "SELECT i.id AS invoiceid, i.orderid, i.invoiceno, i.invoicedate, i.entrydate, i.customerid, i.coupon, 
                 SUM(d.price) AS saleprice, i.shipping, i.roundoff, i.discountpertange, i.discountvalue, 
                 i.totalsavings AS Discount, SUM(d.taxvalue) AS taxvalue, i.grandtotal 
          FROM invoice i 
          INNER JOIN invoicedata d ON i.id = d.invoiceid";

    // Add date filter based on durationval 
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');  
        $q .= " WHERE i.invoicedate = '$durationvals'"; 
    } else if ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));   
        $q .= " WHERE i.invoicedate = '$durationvals'";   
    } else if ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);  
        $rowweeks = mysqli_fetch_array($resultvals);  
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];  
        $q .= " WHERE i.invoicedate >= '$Monday' AND i.invoicedate <= '$Sunday'";  
    } else if ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows); 
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);   
        $firstday = $rowweeksfetch['firstday'];     
        $lastday = $rowweeksfetch['lastday']; 
        $q .= " WHERE i.invoicedate >= '$firstday' AND i.invoicedate <= '$lastday'";  
    } else if ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);   
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $q .= " WHERE i.invoicedate >= '$startDate' AND i.invoicedate <= '$endDate'";  
    }

    $q .= " GROUP BY i.id"; 

    $result = $connection->query($q);  

    while ($row = mysqli_fetch_assoc($result)) {
        $invoiceid = $row['invoiceid'];
        $customerid = $row['customerid'];
        $tax = $row['taxvalue'];

        // Fetch customer payment amounts
        $sql3 = "SELECT SUM(amount) AS amounts FROM customerpayment WHERE customerid='$customerid' AND invoiceid='$invoiceid'";
        $sqlexecutes = mysqli_query($connection, $sql3); 
        $customerpaymentrows = mysqli_fetch_array($sqlexecutes);  
        $amounts = $customerpaymentrows['amounts']; 
        $grandtotal = $row['grandtotal']; 
        $balance =  $grandtotal -$amounts; 

        // Fetch customer details
        $sql2 = "SELECT * FROM customer WHERE id='$customerid'";
        $sqlexecute2 = mysqli_query($connection, $sql2); 
        $customerrows = mysqli_fetch_array($sqlexecute2);

        // Determine customer type
        $customertype = $customerrows['customertype'];
        if ($customertype == 1) {
            $customertype = "Customer";
        } else if ($customertype == 2) {
            $customertype = "Retailer";
        } else {
            $customertype = "sales counter";
        }

        // Prepare line data for Excel
        $lineData = array(
            $row['invoiceno'], 
            $row['invoicedate'], 
            $row['invoicedate'], // Assuming this is the create date
            $row['orderid'], 
            $customerrows['displayname'], 
            $customerrows['phoneno'],
            $row['coupon'], 
            $row['saleprice'],   
            $row['shipping'],
            '', // Packaging Charge
            '', // Payment Discount
            '', // Coupon Discount
            $row['roundoff'], 
            $row['discountvalue'],   
            $tax, 
            $grandtotal, 
            $balance,  
            $customertype, // Create By
            $customertype  // Modify By
        ); 
         // Filter and add only selected fields
        // $selectedLineData = array_intersect_key($lineData, array_flip($selectedFields));
         //array_walk($selectedLineData, 'filterData');
         //$excelData .= implode("\t", array_values($selectedLineData)) . "\n";

        // Apply data filtering
        array_walk($lineData, 'filterData');

        // Concatenate line data into Excel format
        $excelData .= implode("\t", $lineData) . "\n";
    } 

    // Write data to file
    file_put_contents($fileName, $excelData);

    // Update report entry in database
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'"; 
    $sqlexecute3 = mysqli_query($connection, $sql6);    
}


//$report=='1' order  report  
if ($report == '1') {
    // Function to filter Excel data
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // Define Excel headers
    $fields = array(
        'Order Id', 'Order Date', 'Order Status', 'Invoice Id', 'Invoice Date', 
        'Customer Name', 'Customer Mobile', 'Cancel Reason', 'Sale Price', 
        'Shipping Charge', 'Packaging Charge', 'Payment Discount', 'Coupon Discount', 
        'Coupon Code', 'Round Off', 'Discount', 'Tax Amount', 'Total Amount', 
        'Earn Points', 'Redeem Points', 'Due Amount', 'Delivery Mode', 'Payment Mode', 
        'Express Delivery', 'Delivery Slot', 'Delivery Start At', 'Delivery End At', 
        'Delivery Tracking Id', 'Contact Name', 'Contact Mobile', 'Street1', 'Street2', 
        'City', 'State', 'Pincode', 'UTM Id', 'UTM Campaign', 'Created By', 'Modified By'
    );
    $excelData = implode("\t", array_values($fields)) . "\n";

    // Base SQL query
    $q = "SELECT o.createdate AS receiveddate, o.orderid, o.customerid, o.total_tax, o.grandtotal, 
                 o.orderstatus, o.actionstatus, o.invoiceid, o.trackingid, o.deliverypatner, 
                 o.delivereddate, o.trackingdate, o.confirmeddate, o.discount_code, o.roundoff, 
                 o.discount_code_amount,  o.no_of_items, o.total_discount, 
                 i.invoicedate, i.invoiceno,i.shipping,i.roundoff,i.amount AS invoice_amount, i.discountvalue AS invoice_discount, 
                 c.displayname, c.phoneno, c.address AS customer_address, c.city AS customer_city, 
                 c.sstate AS customer_state, c.pincode AS customer_pincode, 
                 c.saddress AS shipping_address, c.scity AS shipping_city, c.spincode AS shipping_pincode, 
                 c.utmid, c.referralcode AS utm_campaign, o.createrid, o.editorid
          FROM orders o
          JOIN customer c ON o.customerid = c.id
          LEFT JOIN invoice i ON o.id = i.id
          WHERE o.delete_status = '0'";

    // Apply date filter based on $durationval
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');
        $q .= " AND DATE(o.createdate) = '$durationvals'";
    } elseif ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));
        $q .= " AND DATE(o.createdate) = '$durationvals'";
    } elseif ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);
        $rowweeks = mysqli_fetch_array($resultvals);
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];
        $durationvals = "Weekly";
        $q .= " AND DATE(o.createdate) >= '$Monday' AND DATE(o.createdate) <= '$Sunday'";
    } elseif ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows);
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);
        $firstday = $rowweeksfetch['firstday'];
        $lastday = $rowweeksfetch['lastday'];
        $durationvals = "Monthly";
        $q .= " AND DATE(o.createdate) >= '$firstday' AND DATE(o.createdate) <= '$lastday'";
    } elseif ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $durationvals = $startDate . "_to_" . $endDate;
        $q .= " AND DATE(o.createdate) >= '$startDate' AND DATE(o.createdate) <= '$endDate'";
    } else {
        $durationvals = "Undefined";
    }

    // Define file name
    $fileName = "reportsfiles/Order-" . $durationvals . ".xls";

    // Execute the query
    $result = $connection->query($q);

    // Check if the query executed successfully
    if (!$result) {
        die("Query failed: " . mysqli_error($connection));
    }

    // Check if there are any results
    if ($result->num_rows == 0) {
        die("No records found for the given duration.");
    }

    // Process the query result
    while ($row = $result->fetch_assoc()) {

        // Determine order status
        $label = "";
        if ($row['actionstatus'] == "1") {
            $label = "New";
        } elseif ($row['actionstatus'] == "2") {
            $label = "Confirmed";
        } elseif ($row['actionstatus'] == "3") {
            $label = "Dispatch";
        } elseif ($row['orderstatus'] == "3") {
            $label = "Delivered";
        } elseif ($row['actionstatus'] == "4") {
            $label = "Completed";
        } elseif ($row['canceled'] == "6") {
            $label = "Completed";
        }

        $total = $row['shipping'] + $row['grandtotal'] + $row['total_tax'];
        $customerid=$row['customerid'];
        
        $sql2 = "SELECT * FROM customer WHERE id='$customerid'";
        $sqlexecute2 = mysqli_query($connection, $sql2); 
        $customerrows = mysqli_fetch_array($sqlexecute2);

        // Determine customer type
        $customertype = $customerrows['customertype'];
        if ($customertype == 1) {
            $customertype = "Customer";
        } else if ($customertype == 2) {
            $customertype = "Retailer";
        } else {
            $customertype = "sales counter";
        }

        // Prepare line data
        $lineData = array(
            $row['orderid'], $row['receiveddate'], $label, $row['invoiceno'], $row['invoicedate'], 
            $row['displayname'], $row['phoneno'], $row['cancel_reason'], $row['grandtotal'], 
            $row['shipping'], $row['packaging_charge'], $row['payment_discount'], $row['invoice_discount'], 
            $row['discount_code'], $row['roundoff'], $row['discount_code_amount'], $row['total_tax'], 
            $total, 
            $row['earn_points'], $row['redeem_points'], $row['due_amount'], 
            $row['delivery_mode'], $row['payment_mode'], $row['express_delivery'], $row['delivery_slot'], 
            $row['delivery_start_at'], $row['delivery_end_at'], $row['trackingid'], $row['displayname'], 
            $row['phoneno'], $row['customer_address'], $row['shipping_address'], $row['customer_city'], 
            $row['customer_state'], $row['customer_pincode'], $row['utmid'], $row['utm_campaign'], 
            $customertype, $customertype
        );
        
        // Filter and add to Excel data
        array_walk($lineData, 'filterData');
        $excelData .= implode("\t", array_values($lineData)) . "\n";
    }

    // Ensure the directory is writable
    if (!is_writable('reportsfiles')) {
        die("Directory 'reportsfiles' is not writable. Please check permissions.");
    }

    // Save data to Excel file
    if (file_put_contents($fileName, $excelData) === false) {
        die("Failed to write data to file '$fileName'.");
    }

    // Update reports table with file name
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'";
    $sqlexecute3 = mysqli_query($connection, $sql6);
}


/// report ='10' ordero and order item report
if ($report == '10') {

    // Create connection
    $connection = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    // Function to sanitize data for Excel output
    function filterData(&$str) {
        $str = preg_replace("/\t/", "\\t", $str);
        $str = preg_replace("/\r?\n/", "\\n", $str);
        if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
    }

    // Define the file name for the Excel file
    $fileName = "reportsfiles/order_and_OrderItem_Report-" . $durationvals . ".xls";

    // Define the column headers for the Excel file
    $fields = array(
        'Order Id', 'Order Date', 'Order Status', 'Type', 'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile',
        'Cancel Reason', 'Sale Price', 'Shipping Charge', 'Payment Charge', 'Packaging Charge', 'Coupon Code', 'Round Off',
        'Discount', 'Payment Discount', 'Tax Amount', 'Earn Points', 'Redeem Points', 'Due Amount', 'Total Amount', 
        'Delivery Mode', 'Payment Mode', 'Express Delivery', 'Delivery Slot', 'Delivery Start At', 'Delivery End At',
        'Delivery Tracking Id', 'Contact Name', 'Contact Mobile', 'Street1', 'Street2', 'City', 'Pincode', 
        'UTM Id', 'UTM Campaign', 'Delivery Partner Name', 'Delivery Name', 'Item Name', 'Item Sku', 'Item Price', 
        'Item Qty', 'HSN', 'State', 'State Code', 'SGST', 'SGST%', 'CGST', 'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 
        'Item Tax', 'Item Total', 'Created By', 'Modified By'
    );

    // Display column names as the first row
    $excelData = implode("\t", $fields) . "\n";

    // Base query for orders and order items, including the additional query
    $q = "SELECT o.createdate, o.orderid, o.customerid, o.total_tax, o.grandtotal, 
                 o.orderstatus, o.actionstatus, o.invoiceid, o.trackingid, o.deliverypatner, 
                 o.delivereddate, o.trackingdate, o.confirmeddate, o.discount_code, o.roundoff, 
                 o.discount_code_amount, o.no_of_items, o.total_discount, 
                 i.invoicedate, i.invoiceno, i.shipping, i.roundoff, i.amount AS invoice_amount, 
                 i.discountvalue AS invoice_discount, c.customertype,c.displayname, c.phoneno, c.address AS customer_address, 
                 c.city AS customer_city, c.sstate AS customer_state, c.pincode AS customer_pincode, 
                 c.saddress AS shipping_address, c.scity AS shipping_city, c.spincode AS shipping_pincode, 
                 c.utmid, c.referralcode AS utm_campaign, o.createrid, o.editorid,
                 pd.productname AS item_name, pd.hsn AS hsn, pd.sku, id.qty AS quantity, id.price AS price,
                 i.id AS invoiceid, i.orderid AS inv_orderid, i.invoicedate AS inv_invoicedate, 
                 i.entrydate, i.coupon, SUM(d.price) AS saleprice, i.discountpertange, i.discountvalue AS inv_discountvalue, 
                 i.totalsavings AS inv_discount, SUM(d.taxvalue) AS inv_taxvalue, i.grandtotal AS inv_grandtotal
          FROM orders o
          JOIN customer c ON o.customerid = c.id
          LEFT JOIN invoice i ON o.id = i.id
          LEFT JOIN invoicedata id ON i.id = id.invoiceid
          LEFT JOIN product pd ON id.productid = pd.id
          LEFT JOIN customerpayment cp ON cp.id = i.id
          INNER JOIN invoicedata d ON i.id = d.invoiceid
          WHERE o.delete_status = '0'";

    // Add date filter based on invoice date
    if ($durationval == 1) {
        $durationvals = date('Y-m-d');  
        $q .= " AND i.invoicedate = '$durationvals'"; 
    } else if ($durationval == 2) {
        $durationvals = date("Y-m-d", strtotime("yesterday"));   
        $q .= " AND i.invoicedate = '$durationvals'";   
    } else if ($durationval == 3) {
        $sqlvals = "SELECT SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 7) AS Monday, SUBDATE(CURDATE(), WEEKDAY(CURDATE()) + 1) AS Sunday";
        $resultvals = $connection->query($sqlvals);  
        $rowweeks = mysqli_fetch_array($resultvals);  
        $Monday = $rowweeks['Monday'];
        $Sunday = $rowweeks['Sunday'];  
        $q .= " AND i.invoicedate >= '$Monday' AND i.invoicedate <= '$Sunday'";  
    } else if ($durationval == 4) {
        $sqlvalsrows = "SELECT LAST_DAY(CURDATE() - INTERVAL 2 MONTH) + INTERVAL 1 DAY AS firstday, LAST_DAY(CURDATE() - INTERVAL 1 MONTH) AS lastday";
        $resultvalsquery = $connection->query($sqlvalsrows); 
        $rowweeksfetch = mysqli_fetch_array($resultvalsquery);   
        $firstday = $rowweeksfetch['firstday'];     
        $lastday = $rowweeksfetch['lastday']; 
        $q .= " AND i.invoicedate >= '$firstday' AND i.invoicedate <= '$lastday'";  
    } else if ($durationval == 5) {
        $customdates = addslashes($_POST['customdates']);   
        $dateRange = explode(' - ', $customdates);
        $startDate = date('Y-m-d', strtotime($dateRange[0]));
        $endDate = date('Y-m-d', strtotime($dateRange[1]));
        $q .= " AND i.invoicedate >= '$startDate' AND i.invoicedate <= '$endDate'";  
    }

    $q .= " GROUP BY i.id, o.id, pd.id";  // Adding GROUP BY to avoid SQL errors with aggregate functions

    $result = $connection->query($q);  

    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['paymenttype']) {
            case '1':
                $paymenttype = "Cash";
                $paymentmode = "Cash";
                break;
            case '2':
                $paymenttype = "Card";
                $paymentmode = "Card"; // Adjusted to match payment type
                break;
            case '3':
                $paymenttype = "UPI";
                $paymentmode = "Bank";
                break;
            case '4':
                $paymenttype = "Bank Transfer"; // Example: Adjust as per your system's logic
                $paymentmode = "Bank";
                break;
            case '5':
                $paymenttype = "Cheque";
                $paymentmode = "Cheque"; // Adjusted to match payment type
                break;
            default:
                $paymenttype = "N/A";
                $paymentmode = "N/A";
        }
        
        // Determine order status
        $label = "";
        if ($row['actionstatus'] == "1") {
            $label = "New";
        } elseif ($row['actionstatus'] == "2") {
            $label = "Confirmed";
        } elseif ($row['actionstatus'] == "3") {
            $label = "Dispatched";
        } elseif ($row['actionstatus'] == "4") {
            $label = "Delivered";
        } elseif ($row['actionstatus'] == "5") {
            $label = "Cancelled";
        } elseif ($row['actionstatus'] == "6") {
            $label = "Completed";
        } else {
            $label = "Unknown";
        }
        $customertype = $customerrows['customertype'];
        if ($customertype == 1) {
            $customertype = "Customer";
        } else if ($customertype == 2) {
            $customertype = "Retailer";
        } else {
            $customertype = "sales counter";
        }


        $total = $row['price'] * $row['quantity'];
        $sgst_percent = 2.5;
        $cgst_percent = 2.5;
        $igst_percent = 5.0;
        $sgst = $total * ($sgst_percent / 100);
        $cgst = $total * ($cgst_percent / 100);
        $igst = $total * ($igst_percent / 100);
        $itemtotal = $total + $sgst + $cgst + $igst+$row['shipping'];

        // Prepare line data for Excel
        $lineData = array(
            $row['orderid'], 
            $row['createdate'], 
            $label, 
            $row['Type'], 
            $row['invoiceno'], 
            $row['invoicedate'], 
            $row['displayname'], 
            $row['phoneno'], 
            '', // Cancel Reason - Placeholder
            $row['saleprice'], 
            $row['shipping'], 
            '', // Payment Charge - Placeholder
            '', // Packaging Charge - Placeholder
            $row['coupon'], 
            $row['roundoff'], 
            $row['inv_discount'], 
            '', // Payment Discount - Placeholder
            $row['inv_taxvalue'], 
            '', // Earn Points - Placeholder
            '', // Redeem Points - Placeholder
            '', // Due Amount - Placeholder
            $row['inv_grandtotal'], 
            $row['Delivery Mode'], // Delivery Mode - Placeholder
            $paymenttype, 
            '', // Express Delivery - Placeholder
            '', // Delivery Slot - Placeholder
            '', // Delivery Start At - Placeholder
            '', // Delivery End At - Placeholder
            $row['trackingid'], 
            $row['displayname'], // Contact Name - Placeholder
            $row['phoneno'], // Contact Mobile - Placeholder
            $row['customer_address'], 
            $row['shipping_address'], 
            $row['customer_city'],  
            $row['customer_pincode'], 
            $row['utmid'], 
            $row['utm_campaign'], 
            $row['deliverypatner'], 
            '', // Delivery Name - Placeholder
            $row['item_name'], 
            $row['sku'], 
            $row['price'], 
            $row['quantity'], 
            $row['hsn'], 
            $row['customer_state'], 
            '', // State Code - Placeholder
            $sgst, 
            $sgst_percent, 
            $cgst, 
            $cgst_percent, 
            $igst, 
            $igst_percent, 
            0, // CESS - Placeholder
            0, // CESS% - Placeholder
            $total, 
            $itemtotal,
            $customertype, 
            $customertype
        ); 

        // Apply data filtering
        array_walk($lineData, 'filterData');

        // Concatenate line data into Excel format
        $excelData .= implode("\t", $lineData) . "\n";
    } 

    // Write data to file
    file_put_contents($fileName, $excelData);

    // Update report entry in the database
    $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'"; 
    $sqlexecute3 = mysqli_query($connection, $sql6);
}

	  
      //whatsapp bot report

      if ($report == '11') {
        // Filter function for Excel data
        function filterData(&$str) { 
            $str = preg_replace("/\t/", "\\t", $str); 
            $str = preg_replace("/\r?\n/", "\\n", $str); 
            if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"'; 
        }
    
        // Determine the duration for the filename
        if ($durationval == 1) {
            $durationvals = date('Y-m-d');
        } elseif ($durationval == 2) {
            $durationvals = date("Y-m-d", strtotime("yesterday"));
        } elseif ($durationval == 3 || $durationval == 4) {
            // Date variables for weekly or monthly data
            $durationvals = $durationval == 3 ? "Weekly" : "Monthly";
        } elseif ($durationval == 5) {
            $customdates = addslashes($_POST['customdates']);
            $dateRange = explode(' - ', $customdates);
            $startDate = date('Y-m-d', strtotime($dateRange[0]));
            $endDate = date('Y-m-d', strtotime($dateRange[1]));
            $durationvals = $startDate . "_to_" . $endDate;
        } else {
            $durationvals = "Undefined";  // Default if no valid durationval is provided
        }
    
        // Define file name
        $fileName = "reportsfiles/WhatsappBot-" . $durationvals . ".xls";
    
        // Define Excel headers
        $fields = array('Number', 'Order No', 'Invoice No','Customer Name', 'Delivery Partner Name', 'Tracking ID');
        $excelData = implode("\t", array_values($fields)) . "\n"; 
    
        // Initial query to fetch order data
        $q = "SELECT o.id, o.createdate AS date, o.orderid AS orderno, c.phoneno,c.displayname, o.deliverypatner, o.trackingid 
              FROM orders o 
              INNER JOIN customer c ON c.id = o.customerid 
              WHERE o.delete_status = '0'";
    
        // Apply date range filters
        if ($durationval == 1 || $durationval == 2) {
            $q .= " AND o.createdate = '$durationvals'";
        } elseif ($durationval == 3) {
            $sqlvals = "SELECT subdate(curdate(), WEEKDAY(curdate()) + 7) AS Monday, subdate(curdate(), WEEKDAY(curdate()) + 1) AS Sunday";
            $resultvals = $connection->query($sqlvals);    
            if (!$resultvals) {
                die("Error executing weekly date query: " . mysqli_error($connection));
            }
            $rowweeks = mysqli_fetch_array($resultvals);  
            $Monday = $rowweeks['Monday'];
            $Sunday = $rowweeks['Sunday'];
            $q .= " AND o.createdate >= '$Monday' AND o.createdate <= '$Sunday'";
        } elseif ($durationval == 4) {
            $sqlvalsrows = "SELECT last_day(curdate() - interval 2 month) + interval 1 day AS firstday, last_day(curdate() - interval 1 month) AS lastday";
            $resultvalsquery = $connection->query($sqlvalsrows);
            if (!$resultvalsquery) {
                die("Error executing monthly date query: " . mysqli_error($connection));
            }
            $rowweeksfetch = mysqli_fetch_array($resultvalsquery);    
            $firstday = $rowweeksfetch['firstday'];       
            $lastday = $rowweeksfetch['lastday'];
            $q .= " AND o.createdate >= '$firstday' AND o.createdate <= '$lastday'";
        } elseif ($durationval == 5) {
            $q .= " AND o.createdate >= '$startDate' AND o.createdate <= '$endDate'";
        }
    
        $q .= " GROUP BY o.id";    
        $result = $connection->query($q);
    
        if (!$result) {
            die("Error executing main query: " . mysqli_error($connection));
        }
    
        // Process the query result
        while ($row = mysqli_fetch_assoc($result)) {
            $id = $row['id'];
            
            // Query to fetch invoiceno based on orderid
            $sql = "SELECT invoiceno FROM invoice WHERE id = '$id' AND delete_status = '0'";
            $fetchinvoice = mysqli_query($connection, $sql);
            if (!$fetchinvoice) {
                die("Error fetching invoice data: " . mysqli_error($connection));
            }
            $invoiceRow = mysqli_fetch_assoc($fetchinvoice);
            $invoiceno = $invoiceRow ? $invoiceRow['invoiceno'] : 'N/A';  // Use 'N/A' if no invoice found
    
            $phoneno = $row['phoneno']; 
            $orderno = $row['orderno']; 
            $customername=$row['displayname'];
            $deliverypatner = $row['deliverypatner']; 
            $trackingid = $row['trackingid'];
    
            // Include invoiceno in the line data
            $lineData = array($phoneno, $orderno, $invoiceno,$customername, $deliverypatner, $trackingid);
            array_walk($lineData, 'filterData'); 
            $excelData .= implode("\t", array_values($lineData)) . "\n";
        }
    
        // Write to file
        if (file_put_contents($fileName, $excelData) === false) {
            die("Failed to write Excel file.");
        }
    
        // Update reports table with file name
        $sql6 = "UPDATE reports SET excelname='$fileName' WHERE id='$last_id'"; 
        $sqlexecute3 = mysqli_query($connection, $sql6);   
    
      
    }
    
    
	  
  // }
   
   
   
   
   
   
	  
	  /* customer  report end  */ 





?>